//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.11, Page No: 448
//Title : Second law efficiency
 //=======================================================
 package Ex8_11
  class Ex8_11_a
  //=======================================================
  //Variable section 
  Real X_1(unit = "kJ") "Energy of system at intial state";
  Real X_2(unit = "kJ") "Energy of system at final state";
  //=======================================================
  //Parameter section
  parameter Real u_1(unit = "kJ/Kg") = 2793.7 "Enthalpy at initial state of surroundings at pressure 1 MPa and temperature 300 deg.C from table A-6";
  parameter Real v_1(unit = "m3/Kg") = 0.25799 "specific volume at initial state of surroundings pressure 1 MPa and temperature 300 deg.C from table A-6";
  parameter Real s_1(unit = "kJ/Kg.K") = 7.1246 "specific heat at initial state of surroundings pressure 1 MPa and temperature 300 deg.C from table A-6";
  parameter Real u_0(unit = "kJ/Kg") = 104.83 "Enthalpy at dead state of surroundings at pressure 100 kPa and temperature 25 deg.C from table A-4";
  parameter Real v_0(unit = "m3/Kg") = 0.00103 "specific volume at dead state of surroundings pressure 100 kPa and temperature 25 deg.C from table A-4";
  parameter Real s_0(unit = "kJ/Kg.K") = 0.3672 "specific heat at dead state of surroundings pressure 100 kPa and temperature 25 deg.C from table A-4";
  parameter Real u_2(unit = "kJ/Kg") = 2577.1 "Enthalpy at final state of surroundings at pressure 200 kPa and temperature 150 deg.C from table A-6";
  parameter Real v_2(unit = "m3/Kg") = 0.95986 "specific volume at final state of surroundings pressure 200 kPa and temperature 150 deg.C from table A-6";
  parameter Real s_2(unit = "kJ/Kg.K") = 7.281 "specific heat at dead state of surroundings pressure 200 kPa and temperature 150 deg.C from table A-6";
  parameter Real m(unit = "Kg") = 0.05 "Mass of steam";
  parameter Real To(unit = "deg.C") = 25 "Temperature of surroundings at dead state";
  parameter Real Po(unit = "kPa") = 100 "Pressure of surroundings at dead state";
  //=======================================================
  //Equation section
  equation
  X_1 = m*(((u_1 - u_0) - ((To + 273.15)*(s_1 - s_0))) + Po*(v_1 - v_0));
  X_2 = m*(((u_2 - u_0) - ((To + 273.15)*(s_2 - s_0))) + Po*(v_2 - v_0));
  //=======================================================
  
  end Ex8_11_a;

  class Ex8_11_b
  //=======================================================
  //Variable section 
  Real del_X(unit = "kJ") "Energy change for a process";
  //=======================================================
  //Parameter section
  Real X_1(unit = "kJ") = 35 "Energy of system at intial state";
  Real X_2(unit = "kJ") = 25.4 "Energy of system at final state";
  //=======================================================
  //Equation section
  equation
  del_X = X_2 - X_1;
  //=======================================================
  end Ex8_11_b;

  class Ex8_11_c
  //=======================================================
  //Variable section 
  Real W_u(unit = "kJ") "Useful work";
  Real X_destroyed(unit = "kJ") "Energy destroyed";
  Real Xdestroyed(unit = "kJ") "Energy destroyed";
  //=======================================================
  //Parameter section
  parameter Real X_1(unit = "kJ") = 35 "Energy of system at intial state";
  parameter Real X_2(unit = "kJ") = 25.4 "Energy of system at final state";
  parameter Real u_1(unit = "kJ/Kg") = 2793.7 "Enthalpy at initial state of surroundings at pressure 1 MPa and temperature 300 deg.C from table A-6";
  parameter Real v_1(unit = "m3/Kg") = 0.25799 "specific volume at initial state of surroundings pressure 1 MPa and temperature 300 deg.C from table A-6";
  parameter Real s_1(unit = "kJ/Kg.K") = 7.1246 "specific heat at initial state of surroundings pressure 1 MPa and temperature 300 deg.C from table A-6";
  parameter Real u_2(unit = "kJ/Kg") = 2577.1 "Enthalpy at final state of surroundings at pressure 200 kPa and temperature 150 deg.C from table A-6";
  parameter Real v_2(unit = "m3/Kg") = 0.95986 "specific volume at final state of surroundings pressure 200 kPa and temperature 150 deg.C from table A-6";
  parameter Real s_2(unit = "kJ/Kg.K") = 7.281 "specific heat at dead state of surroundings pressure 200 kPa and temperature 150 deg.C from table A-6";
  parameter Real m(unit = "Kg") = 0.05 "Mass of steam";
  parameter Real To(unit = "deg.C") = 25 "Temperature of surroundings at dead state";
  parameter Real Po(unit = "kPa") = 100 "Pressure of surroundings at dead state";
  parameter Real W_b_out(unit = "kJ") = 8.8 "Boundary work";
  parameter Real Q_surr(unit = "kJ") = 2 "Heat losses from system to surroundings";
  //=======================================================
  //Equation section
  equation
  W_u = W_b_out - (Po*m*(v_2 - v_1));
  X_destroyed = X_1 - X_2 - W_u;
  Xdestroyed = (To + 273)*((m*(s_2 - s_1)) + (Q_surr/(To + 273)));
  
  //=======================================================
  end Ex8_11_c;

  class Ex8_11_d
  //=======================================================
  //Variable section 
  Real eta_11 "Second law efficiency of this process";
  Real eta11(unit = "%") "Second law efficiency of this process";
  //=======================================================
  //Parameter section
  parameter Real X_1(unit = "kJ") = 35 "Energy of system at intial state";
  parameter Real X_2(unit = "kJ") = 25.4 "Energy of system at final state";
  parameter Real W_u(unit = "kJ") = 5.3 "Energy recovered";
  //=======================================================
  //Equation section
  equation
  eta_11 = W_u/(X_1 - X_2);
  eta11 = eta_11*100;
  //=======================================================
  end Ex8_11_d;
end Ex8_11;
