//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.12, Page No: 451
//Title : Second law efficiency
 //=======================================================
package Ex8_12
class Ex8_12_a
//=======================================================
//Variable section 
Real X_destroyed(unit = "Btu") "Energy destroyed";
//=======================================================
//Parameter section
parameter Real T_2(unit = "deg.C") = 130 "Temperature of surrounding air";
parameter Real m(unit = "lbm") = 2 "Weight of water";
parameter Real To(unit = "deg.C") = 70 "Temperature of surroundings at dead state";
parameter Real Cv(unit = "Btu/lbm.deg.F") = 0.172 "Specific heat at constant volume";
//=======================================================
//Library section
extends Modelica.Math;
//=======================================================
//Equation section
equation
X_destroyed = (To+460)*m*Cv*log((T_2+460)/(To+460));
//=======================================================
end Ex8_12_a;

  class Ex8_12_b
  //=======================================================
  //Variable section 
  Real W_rev(unit = "Btu") "Reversible work";
  Real W_net_in(unit = "Btu") "Net work done";
  //=======================================================
  //Parameter section
  parameter Real T_2(unit = "deg.C") = 130 "Temperature of surrounding air";
  parameter Real m(unit = "lbm") = 2 "Weight of water";
  parameter Real To(unit = "deg.C") = 70 "Temperature of surroundings at dead state";
  parameter Real Cv(unit = "Btu/lbm.deg.F") = 0.172 "Specific heat at constant volume";
  parameter Real X_destroyed(unit = "Btu") = 19.6 "Energy destroyed";
  //=======================================================
  //Equation section
  equation
  W_rev = m*Cv*(T_2-To)-X_destroyed;
  W_net_in = m*Cv*(T_2 - To) - X_destroyed;
  //=======================================================
  end Ex8_12_b;
end Ex8_12;
