//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.14, Page No: 455
//Title : Second law efficiency
 //=======================================================
package Ex8_14
  class Ex8_14_a
  //=======================================================
    //Variable section
    Real V_1(unit = "m3") "Initial volume of argon gas";
    Real W_b(unit = "kJ") "Boundary work";
    Real W_surroundings(unit = "kJ") "Surrounding work";
    Real W_u(unit = "kJ") "Useful work";
    Real Q_in(unit = "kJ") "Heat input";
    //=======================================================
    //Parameter section
    parameter Real P1(unit = "kPa") = 350 "Initial pressure of argon gas";
    parameter Real V_2(unit = "m3") = 0.02 "Final volume of argon gas";
    parameter Real Po(unit = "kPa") = 100 "Atmospheric pressure";
    //=======================================================
    //Library section
    extends Modelica.Math;
    //=======================================================
    //Equation section
  equation
  V_2 = 2*V_1;
  W_b = P1*V_1*log(V_2/V_1);
  W_surroundings = Po*(V_2 - V_1);
  W_u = (W_b - W_surroundings);
  Q_in = W_b;
  //=======================================================
  end Ex8_14_a;

  class Ex8_14_b
  //=======================================================
    //Variable section
    Real X_destroyed(unit = "kJ") "Energy destroyed";
    Real S_gen(unit = "kJ/K") "Entropy generation";
  //=======================================================
    //Parameter section
    parameter Real Q_in(unit = "kJ") = 2.43 "Heat input";
    parameter Real T_sys(unit = "K") = 400 "Tempertaure of system";
    parameter Real T_R(unit = "K") = 1200 "Final volume of argon gas";
    parameter Real To(unit = "K") = 300 "Atmospheric temperature";
    //=======================================================
    //Equation section
  equation
  S_gen = ((Q_in/T_sys)-(Q_in/T_R));
  X_destroyed = To*S_gen;
  //=======================================================
  end Ex8_14_b;

  class Ex8_14_c
  //=======================================================
    //Variable section
    Real W_rev_out(unit = "kJ") "Reversible work";
    //=======================================================
    //Parameter section
    parameter Real Q_in(unit = "kJ") = 2.43 "Heat input";
    parameter Real T_sys(unit = "K") = 400 "Tempertaure of system";
    parameter Real T_R(unit = "K") = 1200 "Final volume of argon gas";
    parameter Real To(unit = "K") = 300 "Atmospheric temperature";
    parameter Real W_surr(unit = "kJ") = 1 "Surrounding work";
    //=======================================================
    //Equation section
  equation
  W_rev_out = ((To*Q_in/T_sys)-W_surr)+((1 - (To/T_R))*Q_in);
  //=========================================================
  end Ex8_14_c;
end Ex8_14;
