//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.3, Page No: 429
//Title :  Reversible work and Irreversibility
//=======================================================
class Ex8_3
//=======================================================
//Variable section 
Real eta_th_rev "Thermal efficicency of reversible heat engine";
Real W_rev(unit = "kW") "Amount of power of reversible heat engine";
Real I(unit = "kW") "Power output";
//=======================================================
//Parameter section
parameter Real T_sink(unit = "K") = 300 "Temperature of sink";
parameter Real T_source(unit = "K") = 1200 "Temperature of source";
parameter Real Q_in(unit = "kJ/s") = 500 "Heat engine rate";
parameter Real W_u_out(unit = "kW") = 180 "Power output of the heat engine";
//=======================================================
//Equation section
equation
eta_th_rev = 1-(T_sink/T_source);
W_rev = Q_in*eta_th_rev;
I = W_rev - W_u_out;
//=======================================================
end Ex8_3;