//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.5, Page No: 430
//Title :  Reversible work and Irreversibility
//=======================================================
class Ex8_5
//=======================================================
//Variable section 
Real COP_HP "Coefficient of performance in heat pump";
Real x1;
Real x2;
Real X(unit = "kJ") "Supply of heat from hot iron block in kJ";
Real X_1(unit = "MJ") "Supply of heat from hot iron block in MJ";
//=======================================================
//Parameter section
parameter Real T_L(unit = "deg.C") = 5 "Temperature of surroundings";
parameter Real T_H(unit = "deg.C") = 27 "Temperature of source";
parameter Real I(unit = "kJ") = 8191 "Reversible work in kJ";
parameter Real H(unit = "kJ") = 38925 "Loss of heat from iron box until temperature drops to 27 deg.C";
//=======================================================
//Equation section
equation
//273 is added to convert deg.C to Kelvin
COP_HP = 1/(1 - ((T_L+273)/(T_H+273)));
x1 = COP_HP * I;
x2 = H - I;
X = x1 + x2;
X_1 = X/1000;
//1000 is divided to convert kJ to MJ
//=======================================================
end Ex8_5;