//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.7, Page No: 438
//Title :  Second law efficiency of resistance heater
//=======================================================
class Ex8_7
//=======================================================
//Variable section 
Real m_1(unit = "Kg") "Mass of air in tank";
Real phi_1(unit = "kJ/Kg");
Real X_1(unit = "kJ") "Energy content of compressed air";
Real X_1_1(unit = "MJ") "Energy content of compressed air in MJ";
//=======================================================
//Parameter section
parameter Real P_O(unit = "kPa") = 100 "Initial pressure in kPa";
parameter Real P_1(unit = "MPa") = 1 "Pressure in MPa";
parameter Real T_O(unit = "K") = 300 "Compressed air temperature";
parameter Real V(unit = "m3") = 200 "Volume of tank";
parameter Real R(unit = "kPa.m3/Kg.K") = 0.287 "Universal gas constant";
//=======================================================
//Library section
extends Modelica.Math;
//=======================================================
//Equation section
equation
m_1 = ((P_1*1000*V)/(R*T_O));
phi_1 = R*T_O*(((P_O/(P_1*1000))-1)+(log((P_1*1000)/P_O)));
//1000 is multiplied to convert MPa to kPa
X_1 = m_1*phi_1;
X_1_1 = X_1/1000;
//1000 is divided to convert kPa to MPa
//=======================================================
end Ex8_7;