//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.8, Page No: 440
//Title : Second law efficiency
 //=======================================================
model Ex8_8
//=======================================================
//Variable section 
Real W_in_min(unit = "kJ/Kg") "Minimum work that needs to be supplied to the compressor";
Real del_sigh(unit = "kJ/Kg") "Energy change of the refrigerant during the compression process";
//=======================================================
//Parameter section
parameter Real h_1(unit = "kJ/Kg") = 246.36 "Enthalpy at inlet temperature -10 deg.C and  pressure 0.14MPa";
parameter Real h_2(unit = "kJ/Kg") = 286.69 "Enthalpy at outlet temperature 50 deg.C and pressure 0.8MPa";
parameter Real T_o(unit = "deg.C") = 20 "Temperature of environment";
parameter Real S_1(unit = "kJ/Kg.deg.C") = 0.9724;
parameter Real S_2(unit = "kJ/Kg.deg.C") = 0.9802;
//=======================================================
//Equation section
equation
//273 is added to convert deg.C to Kelvin
del_sigh = (h_2 - h_1) - ((T_o+273)*(S_2 - S_1));
W_in_min = del_sigh;
//=======================================================
end Ex8_8;