//======================================================
//Thermodynamics - An Engineering approach
//Chapter-09, Gas power cycles
//Exercise: 9.6, Page No: 514
//Title : Developement of gas turbines
 //=======================================================
package Ex9_6
  class Ex9_6_a
  //=======================================================
  //Variable section
  Real r_bw "Back-up ratio"; 
  Real r_bw_1(unit = "%") "Back-up ratio"; 
    //=======================================================
    //Parameter section
    parameter Real Ws(unit = "kJ/Kg") = 244.16 "Compressor work from equation 9-19";
    parameter Real W_s(unit = "kJ/Kg") = 606.6 "Temperature for process 2-3";
    parameter Real eta_c = 0.8 "Efficiency of compressor";
    parameter Real eta_T = 0.85 "Efficiency of turbine";
    //=======================================================
    //Equation section
  equation
  r_bw = ((Ws/eta_c)/(W_s*eta_T));
  r_bw_1 = r_bw*100;
  end Ex9_6_a;

  class Ex9_6_b
  //=======================================================
  //Variable section
  Real h2a(unit = "kJ/Kg") "Enthalpy";
  Real q_in(unit = "kJ/Kg") "Input heat load";
  Real W_net(unit = "kJ/Kg") "Net work";
  Real eta_th;
  Real eta_th_1(unit = "%") "Thermal efficiency";
  //=======================================================
    //Parameter section
    parameter Real h1(unit = "kJ/Kg") = 300.19 "Enthalpy at temperature T1";
    parameter Real V1(unit = "in3") = 117 "Volume for process 1-2";
    parameter Real W_in(unit = "kJ/Kg") = 305.2 "Work input";
    parameter Real h2(unit = "kJ/Kg") = 544.35 "Enthalpy at Pr2";
    parameter Real h3(unit = "kJ/Kg") = 1395.94 "Enthalpy at process 2-3 for an isentropic compression of an ideal gas";
    parameter Real W_out(unit = "kJ/Kg") = 515.6 "Work output";
    //=======================================================
    //Equation section
    equation
    h2a = h1 + W_in;
    q_in = h3 - h2a;
    W_net = W_out - W_in;
    eta_th = W_net/q_in;
    eta_th_1 = eta_th*100;
  end Ex9_6_b;

  class Ex9_6_c
  //=======================================================
  //Variable section
  Real h4a(unit = "kJ/Kg") "Enthalpy";
  Real T4(unit = "K") "Temperature at enthalpy h4a taken from table A-17";
  //=======================================================
    //Parameter section
    parameter Real h3(unit = "kJ/Kg") = 1395.94 "Enthalpy at process 2-3 for an isentropic compression of an ideal gas";
    parameter Real W_out(unit = "kJ/Kg") = 515.6 "Work output";
    //=======================================================
    //Equation section
    equation
   h4a = h3 - W_out;
   T4 = 853;
  end Ex9_6_c;
end Ex9_6;
