//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-12, Thermodynamic Property Relations
//Exercise: 12.1
//============================================================================
model Ex12_2
//Variable section
Real Ta(unit = "K")        "Average Temperature";
Real spa(unit = "m3/kg")    "Average specific volume";
Real dt(unit = "K")        "Change in Temperature";
Real dsp(unit = "m3/kg")    "Change in specific volume";
Real dp(unit = "kPa")  "Change in pressure";
//=============================================================================
// Parameters
parameter Real T1(unit ="K") = 300            "Temperature 1";
parameter Real T2(unit ="K")  =302              "Temperature 2";
parameter Real R(unit = "kPa m3/kg K") =0.287 "Universal gas constant";
parameter Real sp_T1(unit = "m3/kg") = 0.87    "Specific volume at Temperature 1";
parameter Real sp_T2(unit = "m3/kg") = 0.86   "Specific volume at Temperature 2";

//=============================================================================
// Equations
equation
Ta=(T1+T2)/2;
spa=(sp_T1+sp_T2)/2;
dt=T2-T1;
dsp=sp_T1-sp_T2;
dp=(R*dt/spa)-(R*Ta*dsp/spa^2);
//"The  answer may slightly vary due to  rounding off values"   
//=============================================================================
end Ex12_2;