//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-12, Thermodynamic Property Relations
//Exercise: 12.6
//============================================================================
model EX12_6
//Variable section
Real p2(unit ="psia")           "Saturated Pressure at -50 deg F";
//=============================================================================
// Parameters
parameter Real T1(unit ="R") =  420          "Temperature 1";
parameter Real T2(unit ="R")  = 410            "Temperature 2";
parameter Real p1(unit ="psia") = 7.432     "Saturated Pressure at -40 deg F";
parameter Real hfg(unit ="BTU/lbm") = 97.1    "Enthalpy of vaporization ";
parameter Real R(unit = "BTU/lbm-R") = 0.01946    "Universal gas constant";
//=============================================================================
// Equations
equation
p2 = 2.71828^(((hfg/R)*((1/T1)-(1/T2))))*(p1) "Saturated Pressure at -50 deg F";// where 2.71828 is used in the place of exponential.
//=============================================================================
end EX12_6;