package Ex14_3
//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-14, Gas-vapor mixtures and Air conditioning
//Exercise: 14.3a
//============================================================================
model Ex14_3_a
//Variable section
Real W1(unit = "kg H2O/kg dry air")   "Specific humidity at state1";
Real W2(unit = "kg H2O/kg dry air")   "Specific humidity at state2";
//=============================================================================
// Parameters
parameter Real Cp(unit = "kJ/kg-K") =1.005   "Specific heat of air";
parameter Real T1(unit = "C") =25   "Dry bulb temperature";
parameter Real T2(unit = "C") =15   "Wet bulb temperature";
parameter Real Ps(unit = "kPa") = 1.7057   "Saturation pressure of water";
parameter Real P(unit = "kPa") = 101.325   "Atmospheric pressure";
parameter Real hfg_2(unit = "kJ/kg") = 2465.4 "Enthalpy hfg2";
parameter Real hg_1(unit = "kJ/kg") = 2546.5 "Enthalpy hg1";
parameter Real hf_2(unit = "kJ/kg") = 62.982 "Enthalpy hf2";
//=============================================================================
// Equations
equation
W2=0.622*Ps/(P-Ps);
W1=((Cp*(T2-T1))+(W2*hfg_2))/(hg_1-hf_2);
//=============================================================================
  end Ex14_3_a;

//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-14, Gas-vapor mixtures and Air conditioning
//Exercise: 14.3b
//============================================================================
model Ex14_3_b
//Variable section
Real W1(unit = "kg H2O/kg dry air")   "Specific humidity at state1";
Real W2(unit = "kg H2O/kg dry air")   "Specific humidity at state2";
Real RH(unit = "%")   "Relative humidity at state1";
//=============================================================================
// Parameters
parameter Real Cp(unit = "kJ/kg-K") =1.005   "Specific heat of air";
parameter Real T1(unit = "C") =25   "Dry bulb temperature";
parameter Real T2(unit = "C") =15   "Wet bulb temperature";
parameter Real Ps(unit = "kPa") = 1.7057   "Saturation pressure of water at 15 deg C";
parameter Real Ps2(unit = "kPa") = 3.1698   "Saturation pressure of water at 25 deg C ";
parameter Real P(unit = "kPa") = 101.325   "Atmospheric pressure";
parameter Real hfg_2(unit = "kJ/kg") = 2465.4 "Enthalpy hfg2";
parameter Real hg_1(unit = "kJ/kg") = 2546.5 "Enthalpy hg1";
parameter Real hf_2(unit = "kJ/kg") = 62.982 "Enthalpy hf2";
//=============================================================================
// Equations
equation
W2=0.622*Ps/(P-Ps);
W1=((Cp*(T2-T1))+(W2*hfg_2))/(hg_1-hf_2);
RH=(W1*P)/((0.622+W1)*Ps2);
//=============================================================================
  end Ex14_3_b;

//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-14, Gas-vapor mixtures and Air conditioning
//Exercise: 14.3c
//============================================================================
model Ex14_3_c
//Variable section
Real W1(unit = "kg H2O/kg dry air")   "Specific humidity at state1";
Real W2(unit = "kg H2O/kg dry air")   "Specific humidity at state2";
Real RH(unit = "%")   "Relative humidity at state1";
Real H(unit = "kJ/kg dry air")   "Enthalpy of air";
//=============================================================================
// Parameters
parameter Real Cp(unit = "kJ/kg-K") =1.005   "Specific heat of air";
parameter Real T1(unit = "C") =25   "Dry bulb temperature";
parameter Real T2(unit = "C") =15   "Wet bulb temperature";
parameter Real Ps(unit = "kPa") = 1.7057   "Saturation pressure of water at 15 deg C";
parameter Real Ps2(unit = "kPa") = 3.1698   "Saturation pressure of water at 25 deg C ";
parameter Real P(unit = "kPa") = 101.325   "Atmospheric pressure";
parameter Real hfg_2(unit = "kJ/kg") = 2465.4 "Enthalpy hfg2";
parameter Real hg_1(unit = "kJ/kg") = 2546.5 "Enthalpy hg1";
parameter Real hf_2(unit = "kJ/kg") = 62.982 "Enthalpy hf2";
//=============================================================================
// Equations
equation
W2=0.622*Ps/(P-Ps);
W1=((Cp*(T2-T1))+(W2*hfg_2))/(hg_1-hf_2);
RH=(W1*P)/((0.622+W1)*Ps2);
H=(Cp*T1)+(W1*hg_1);
//"The answer may vary due to round off error"
//=============================================================================
  end Ex14_3_c;
end Ex14_3;
