//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-15, Chemical Reactions
//Exercise: 15.2
//============================================================================
model Ex15_2
//Variable section
Real m_air(unit = "kg")    "Mass of air";
Real m_f(unit = "kg")      "Mass of fuel";
Real N_air(unit = "kmol")  "Moles of air";
Real m_C(unit = "kg")    "Mass of C in product";
Real m_H2(unit = "kg")    "Mass of H2 in product";
Real af_r(unit = "-")    "air to fuel mass ratio";
Real Pv(unit = "kPa")     " Vapor Pressure";
//=============================================================================
// Parameters
parameter Real M_C(unit = "kg/kmol")=12    "Molecular weight of C";
parameter Real M_O2(unit = "kg/kmol")  =32  "Molecular weight of O2";
parameter Real M_H2(unit = "kg/kmol") =2  "Molecular weight of H2";
parameter Real M_air(unit = "kg/kmol") = 29   "Molecular weight of air";
parameter Real N_C(unit = "kmol") =2    "Moles of C in product";
parameter Real N_H2(unit = "kmol") = 3   "Moles of H2 in product";
parameter Real N1_O2(unit = "kmol") = 4.2    "Moles of O2 in air";
parameter Real N_H2O(unit = "kmol") = 3   "Moles of H2 in product";
parameter Real N_P(unit = "kmol") = 21.49   "Moles of Product";
parameter Real P(unit = "kPa") = 100    "Total pressure";
//=============================================================================
// Equations
equation
N_air=N1_O2*4.76;
m_air=N_air*M_air;
m_C=N_C*M_C;
m_H2=N_H2*M_H2;
m_f=(m_C+m_H2);
af_r=m_air/m_f;
Pv=(N_H2O/N_P)*P;
//Dew point Temperature at Partial pressure Pv is 52.3 C";
//=============================================================================
end Ex15_2;