
//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-15, Chemical Reactions
//Exercise: 15.3
//============================================================================
model Ex15_3
//Variable section

Real N_m(unit = "kmol")  "Moles of moisture in air";
Real N_t(unit = "kmol")  "Total number of Moles ";
Real N_v(unit = "kmol")  "Total number of H20 Moles in products ";
Real Np_t(unit = "kmol")  "Total number of Moles in products ";
Real Pv_air(unit = "kPa")   "Partial pressure of air";
Real Pp_H2O(unit = "kPa")    "Partial presssure of water vapours in products";
//=============================================================================
// Parameters
parameter Real N_C(unit = "kmol") =0.75    "Moles of C in product";
parameter Real N_N2(unit = "kmol") = 5.648     "Moles of N2 in air";
parameter Real N_H2O(unit = "kmol") = 1.53   "Moles of H2 in product";
parameter Real N_P(unit = "kmol") = 21.49   "Moles of Product";
parameter Real P(unit = "kPa") = 101.325    "Total pressure";
parameter Real Pp(unit = "kPa") = 101.325    "Products Pressure";
parameter Real Psat(unit = "kPa") = 2.3392    "Saturation pressure of water at 20 deg C";
parameter Real N_dair(unit = "kmol") = 6.97    "Moles of dry air";
parameter Real x(unit = "-") = 0.8    "Relative humidity"; 
//=============================================================================
// Equations
equation
Pv_air=Psat*x;
N_m=(N_dair*(Pv_air/P))/(1-(Pv_air/P));
N_t=N_m+N_dair;
N_v=N_m+N_H2O;
Np_t=N_v+N_C+N_N2;
Pp_H2O=N_v*Pp/Np_t;
//Dew point Temperature at Partial pressure of water is 60.9 C";
//=============================================================================
end Ex15_3;