//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-16, Chemical and Phase Equilibrium
//Exercise: 16.2
//============================================================================
model Ex16_2
//Variable section
Real Ntot(unit = "kmol")    "Total number of moles";
Real Kp(unit = "-")    "Equilibrium constant";
//=============================================================================
// Parameters
parameter Real Sc_H(unit = "-")= 2    "Stoichiometric coefficeient of monoatomic Hydrogen";
parameter Real Sc_H2(unit = "-") =1   "Stoichiometric coefficeient of diatomic hydrogen";
parameter Real NH(unit = "kmol") = 0.2    "Number of moles of monoatomic Hydrogen";
parameter Real NH2(unit = "kmol") = 0.9    "Number of moles of diatomic Hydrogen";
parameter Real P(unit = "atm") = 10   "Pressure at dissociation";
//=============================================================================
// Equations
equation
Ntot=NH+NH2;
Kp=((NH^Sc_H)/(NH2^Sc_H2))*((P/Ntot)^(Sc_H-Sc_H2));
//Temperature at the corresponding Kp is 3535 K can be referred in table A-28 which is mentioned in Chemical and Phase Equilibrium chapter page no 799 ";
//=============================================================================
end Ex16_2;