//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.17, Page No: 85
//Title: Energy balance
//=====================================================
class Ex2_17
//Variable section
Real E(unit = "kWh/year") "Energy savings";
Real S(unit = "$/year") "Cost savings";
Real t(unit = "years") "Payback period in year";
Real E_1 "Excess intial cost";
//=====================================================
//Parameter section
parameter Real n_1 = 89 "Efficiency of first motor";
parameter Real n_2= 93.2 "Efficiency of second motor";
parameter Real Cost(unit = "$/kWh") = 0.08 "Cost of electricity";
parameter Real h(unit = "hr") = 3500 "Operating hours per year";
parameter Real P(unit = "hp") = 60 "Shaft power";
parameter Real C_high(unit = "$") = 5160 "Prize of high efficiency motor";
parameter Real C_Std(unit = "$") = 4520 "Prize of standard efficiency motor";
//=====================================================
//Equation section
equation
E = (P*0.7457*h*((1/(n_1/100))-(1/(n_2/100))));
S = E*Cost;
E_1 = C_high-C_Std;
t = E_1/S;
//======================================================
end Ex2_17;