//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.19, Page No: 91
//Title: Energy and environment
//=====================================================
model Ex2_19
//Variable section
Real Q_C(unit = "W") "Heat loss due to convection";
Real Q_r(unit = "W") "Heat loss due to radiation";
Real Q(unit = "W") "Heat loss from the person";
//=====================================================
//Parameter section
parameter Real T_1(unit = "deg.C") = 20 "Temperature of room";
parameter Real T_2(unit = "deg.C") = 29 "Temperature of body";
parameter Real A(unit = "m2") = 1.6 "Surface area";
parameter Real h(unit = "W/m2.C") = 6 "Convective heat transfer coefficent";
parameter Real episilon = 0.95;
parameter Real sigma(unit = "W/m2.K4") = 5.67e-8 "Stefans boltzman constant";
//=====================================================
//Equation section
equation
Q_C = h*A*(T_2-T_1);
Q_r = episilon*sigma*A*(((T_2+273)^4)-((T_1+273)^4));
Q = Q_C + Q_r;
//======================================================
end Ex2_19;