//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.7, Page No: 67 
//Title: Power transmission by the shaft of a car
//=====================================================
class Ex2_7
 //Variable section
 Real W_sh(unit = "kW") "Power transmitted through the shaft of the car";
 Real W(unit = "hp") "Shaft power in hp";
 
 //=====================================================
 //Parameter section
 parameter Real N(unit = "rpm") = 4000;
 parameter Real T(unit = "Nm") = 200 "Torque";
 //=====================================================
 //Library section
 extends Modelica.Constants;
  //=====================================================
 //Equation section
 equation
W_sh = ((2*pi*N*T)/(1000*60));
//1000 is divided to convert W to kW and 60 is divided to convert minutes to seconds
W = W_sh*1.34102;
 //=====================================================
end Ex2_7;