//======================================================
//Thermodynamics - An Engineering approach
//Chapter-04, Energy analysis of closed circuit
//Exercise: 4.11, Page No: 190
//Title : Internal energy, enthalpy and specific heats of solids and liquids
class Ex4_11
//Variable section
Real h_P_T(unit = "kJ/Kg") "Amount of paddle wheel work done on the system";
//=====================================================
//Parameter section
parameter Real P(unit = "kPa") = 101.42 "Pressure of air";
parameter Real P_sat(unit = "kPa") = 15000 "Saturation pressure";
parameter Real v_ft(unit = "m3.Kg") = 0.001;
parameter Real h_ft(unit = "kJ/Kg") = 419.17  "Enthalpy at saturated liquid at 100 deg.C";
//=====================================================
//Equation section
equation
h_P_T = h_ft + (v_ft*(P_sat - P));
//=====================================================
end Ex4_11;