//======================================================
//Thermodynamics - An Engineering approach
//Chapter-04, Energy analysis of closed circuit
//Exercise: 4.12, Page No: 191
//Title : Internal energy, enthalpy and specific heats of solids and liquids
//=====================================================
class Ex4_12
//Variable section
Real m_water(unit = "Kg") "Mass of water in Kg";
Real T_2(unit = "deg.C") "Final temperature in deg.C";
//=====================================================
//Parameter section
parameter Real v(unit = "kPa") = 0.001 "Specific volume in m3/Kg";
parameter Real V(unit = "m3/Kg") = 0.5 "Volume in m3";
parameter Real m_ice(unit = "Kg") = 50 "Mass of ice";
parameter Real T_ice(unit = "deg.C") = 80 "Initial temperature of ice";
parameter Real T_w(unit = "deg.C") = 25 "Initial temperature of water";
parameter Real c_ice(unit = "") = 0.45 "Specific heat of ice";
parameter Real c_w(unit = "") = 4.18 "Specific heat of water";
//=====================================================
//Equation section
equation
m_water = V/v;
T_2 = ((m_ice*c_ice*T_ice)+(m_water*c_w*T_w))/((m_ice*c_ice)+(m_water*c_w));
//=====================================================
end Ex4_12;
//=====================================================