//======================================================
//Thermodynamics - An Engineering approach
//Chapter-04, Energy analysis of closed circuit
//Exercise: 4.2, Page No: 169
//Title:Moving boundary work
//===================================================
class Ex4_2
//Variable section
Real W_b(unit = "BtU") "Workdone by the steam";
//=====================================================
//Parameter section
parameter Real m(unit = "lbm") = 10 "Mass of steam";
parameter Real P(unit = "psia") = 60 "Steam pressure at 320 deg.F";
parameter Real V_2(unit = "ft3/lbm") = 8.3548 "Specific volume at 60 psia, 400 deg.F";
parameter Real V_1(unit = "ft3/lbm") = 7.4863 "Specific volume at 60 psia, 320 deg.F";
//=====================================================
//Equation section
equation
W_b = (m*P*(V_2-V_1))/5.404;
//5.404 converts psia ft3 to BtU
//======================================================
end Ex4_2;