//======================================================
//Thermodynamics - An Engineering approach
//Chapter-04, Energy analysis of closed circuit
//Exercise: 4.4, Page No: 172
//Title : Polytropic process
//===================================================
class Ex4_4
//Variable section
Real V_2(unit = "m3") "Final volume";
Real x(unit = "m") "Displacement of piston";
Real F(unit = "kN") "Spring force";
Real P_1(unit = "kPa") "Pressure due to piston";
Real P(unit = "kPa") "Final presure";
Real W(unit = "kJ") "Work done";
Real W_spring(unit = "kJ") "Fraction of work due to spring"; 
//=====================================================
//Parameter section
parameter Real A(unit = "m2") = 0.25 "Initial pressure";
parameter Real V_1(unit = "m3") = 0.05 "Intial volume";
parameter Real k(unit = "kN/m") = 150 "Spring constant";
parameter Real P_o(unit = "kPa") = 200 "Intial presure";
//=====================================================
//Equation section
equation
V_2 = 2*V_1;
x = (V_2 - V_1)/A;
F = k*x;
P_1 = F/A;
P = P_1+P_o;
W = ((P_o+P)/2)*(V_2-V_1);
W_spring = ((P-P_o)*V_1)/2;

//======================================================
end Ex4_4;