package Ex4_7
  class Ex4_7_a
  //==================================================
  //Variable Section
  Real del_u(unit = "kJ/Kg") "Change in internal energy of air";
  
  //==================================================
  //Parameter Section
  parameter Real u1(unit = "kJ/Kg") = 214.07 "Internal energy of air at 300K";
  parameter Real u2(unit = "kJ/Kg") = 434.78 "Internal energy of air at 600K";
  
  //==================================================
  //Equation Section
  equation
  del_u = u2 - u1;
  
  end Ex4_7_a;

  class Ex4_7_b
  //==================================================
  //Variable Section
  Real del_u(unit = "kJ/Kg") "Change in internal energy";
  
  //==================================================
  //Parameter Section
  parameter Real del_u1(unit = "kJ/Kmol") = 6447 "Internal energy";
  parameter Real M(unit = "Kg/Kmol") = 28.97 "Molar mass of air";
  
  //==================================================
  //Equation Section
  equation
  del_u = del_u1/M;
  
  end Ex4_7_b;

  class Ex4_7_c
  
  //==================================================
  //Variable Section
  Real T_avg(unit = "K") "Average temperature";
  Real del_u(unit = "kJ/Kg") "Internal energy";
  
  //==================================================
  //Parameter Section
  parameter Real cv_avg(unit = "kJ/Kg.K") = 0.733 "Average value of the constant-volume specific heat";
  parameter Real T1(unit = "K") = 300 "Intial temperature of air";
  parameter Real T2(unit = "K") = 600 "Final temperature of air";
  
  //==================================================
  //Equation Section
  equation
  T_avg = ((T1 + T2)/2);
  del_u = (cv_avg*(T2 - T1));
  end Ex4_7_c;
end Ex4_7;
