//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.10, Page No: 242
//Title : Heat Exchangers
//===================================================
package Ex5_10
  class Ex5_10_a
  //=================================================
  //Variable section
  Real m_w(unit = "Kg/min") "Mass flow of saturated liquid";
  //=================================================
  //Parameter section
  parameter Real m_R(unit = "Kg/min") = 6 "Refrigerant mass flow rate";
  parameter Real h_1(unit = "kJ/Kg") = 62.982 "Enthalpy at 15 deg.C from table A_4";
  parameter Real h_2(unit = "kJ/Kg") = 104.83 "Enthalpy at 25 deg.C from table A_4";
  parameter Real h_3(unit = "kJ/Kg") = 303.85 "Enthalpy at  70 deg.C and 1 MPa from table A_11";
  parameter Real h_4(unit = "kJ/Kg") = 100.87 "Enthalpy at  35 deg.C and 1 MPa from table A_11";
  //================================================
  //Equation section
  equation
  m_w = (m_R * (h_4 - h_3))/(h_1 - h_2);
  end Ex5_10_a;

  class Ex5_10_b
  //=================================================
  //Variable section
  Real Qw_in(unit = "kJ/min") "Heat transfer from refrigerant to water";
  //=================================================
  //Parameter section
  parameter Real m_w(unit = "Kg/min") = 29.1025 "Mass flowrate of saturated liquid";
  parameter Real h_1(unit = "kJ/Kg") = 62.982 "Enthalpy at 15 deg.C from table A_4";
  parameter Real h_2(unit = "kJ/Kg") = 104.83 "Enthalpy at 25 deg.C from table A_4";
  //================================================
  //Equation section
  equation
  Qw_in = m_w*(h_2 - h_1);
  end Ex5_10_b;
end Ex5_10;
