//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.3, Page No: 229
//Title : Flow work and the energy of a flowing fluid
//===========================================================
package Ex5_3
  class Ex5_3_a
  //Variable section 
  Real m(unit = "Kg") "Mass in Kg";
  Real m_1(unit = "Kg/min") "Mass flowrate in Kg/min";
  Real m1(unit = "Kg/sec") "Mass flowrate in Kg/sec";
  Real V(unit = "m/s") "Exit velocity";
  //=========================================================
  //parameter section
  parameter Real del_V(unit = "l") = 0.6 "Volume";
  parameter Real V_f(unit = "m3/Kg") = 0.001053 "Specific volume of saturated liquid water at 150 kPa";
  parameter Real V_g(unit = "m3/Kg") = 1.1594 "Specific volume of saturated water vapour at 150 kPa";
  parameter Real Ac(unit = "m2") = 8e-6   "Area";
  parameter Real del_t(unit = "min") = 40 "time taken";
  //=========================================================
  //Equation section
  equation
  m = del_V/(V_f*1000);
  //1000 is divided to convert litres to m3
  m_1 = m/del_t;
  m1 = m_1/60;
  //60 is divided to convert minutes to seconds
  V = (m1*V_g)/Ac;
  //=========================================================
  end Ex5_3_a;

  class Ex5_3_b
  //Variable section 
  Real e_flow(unit = "kJ/Kg") "Total energy of exiting steam";
  Real teta(unit = "kJ/Kg");
  //=========================================================
  //parameter section
  parameter Real h(unit = "kJ/Kg") = 2693.1 "Enthalpy in kJ/Kg";
  parameter Real u(unit = "kJ/Kg") = 2519.2 "Internal energy in kJ/Kg";
  //=========================================================
  //Equation section
  equation
  e_flow = h - u;
  teta = h;
  //=========================================================
  end Ex5_3_b;

  class Ex5_3_c
  //Variable section 
  Real E_mass(unit = "kW") "Total energy of exiting steam per unit mass";
  //=========================================================
  //parameter section
  parameter Real eta(unit = "kJ/Kg") = 2693.1 "Enthalpy in kJ/Kg";
  parameter Real m1(unit = "Kg/s") = 2.37e-4 "Mass flow rate in Kg/s";
  //=========================================================
  //Equation section
  equation
  E_mass = m1 * eta;
  //=========================================================
  end Ex5_3_c;
end Ex5_3;
