//======================================================
//Thermodynamics - An Engineering approach
//Chapter-06, The second law of thermodynamics
//Exercise: 6.4, Page No: 291
//Title : Refrigeration and heat pumps
//=======================================================
package Ex6_4
  class Ex6_4_a
  //=======================================================
  //Variable section 
  Real W_net_in_1(unit = "kJ/hr") "Power consumed by heat pump in kJ/hr";
  Real W_net_in(unit = "kW") "Power consumed by heat pump in kW";
  //=======================================================
  //Parameter section
  parameter Real Q_H(unit = "kJ/hr") = 80000 "Rate of heat loss";
  parameter Real COP_HP = 2.5 "Coefficient of performance of heat pump";
  //=======================================================
  //Equation section
  equation
  W_net_in_1 = Q_H/COP_HP;
  W_net_in = W_net_in_1/3600;
  //3600 is divided to convert hours to seconds
  //=======================================================
  end Ex6_4_a;

  class Ex6_4_b
  //=======================================================
  //Variable section 
  Real Q_L(unit = "kJ/hr") "Rate of heat absorbed from the cold outdoor air";
  //=======================================================
  //Parameter section
  parameter Real Q_H(unit = "kJ/hr") = 80000 "Rate of heat loss";
  parameter Real W_net_in_1(unit = "kJ/hr") = 32000 "Power consumed by heat pump in kJ/hr";
  //=======================================================
  //Equation section
  equation
  Q_L = (Q_H - W_net_in_1);
  //=======================================================
  end Ex6_4_b;
end Ex6_4;
