//======================================================
//Thermodynamics - An Engineering approach
//Chapter-06, The second law of thermodynamics
//Exercise: 6.5, Page No: 306
//Title : Carnot heat engine
//=======================================================
package Ex6_5
  class Ex6_5_a
  //=======================================================
  //Variable section 
  Real eta_th_C "Thermal efficiency of carnot heat engine";
  //=======================================================
  //Parameter section
  parameter Real T_L(unit = "deg.C") = 30 "Rejects heat to a low temperature";
  parameter Real T_H(unit = "deg.C") = 652 "High temperature source";
  //=======================================================
  //Equation section
  equation
  eta_th_C = (1-((T_L+273)/(T_H+273)));
  //273 is added to convert deg.C to Kelvin
  //=======================================================
  end Ex6_5_a;

  class Ex6_5_b
  //=======================================================
  //Variable section 
  Real Q_L_rev(unit = "kJ") "Amount of heat rejected by reversible heat engine";
  //=======================================================
  //Parameter section
  parameter Real T_L(unit = "deg.C") = 30 "Rejects heat to a low temperature";
  parameter Real T_H(unit = "deg.C") = 652 "High temperature source";
  parameter Real QH_rev(unit = "kJ") = 500 "Heat in kJ";
  //=======================================================
  //Equation section
  equation
  Q_L_rev = ((T_L+273)/(T_H+273))*QH_rev;
  //273 is added to convert deg.C to Kelvin
  //=======================================================
  end Ex6_5_b;
end Ex6_5;
