//======================================================
//Thermodynamics - An Engineering approach
//Chapter-06, The second law of thermodynamics
//Exercise: 6.8, Page No: 314
//Title : The carnot refrigerator and heat pump
//=======================================================
class Ex6_8
//=======================================================
//Variable section 
Real W_ref(unit = "W") "Heat generated by the light bulb";
Real W_total(unit = "W") "Additional power consumed by refrigerator";
Real t(unit = "hr/year") "Annual hours or Number of hours in a year";
Real t_2(unit = "hrs/year") "Normal operating hours";
Real t_3(unit ="hrs/year") "Addition operating hours";
Real P(unit = "kWh/year") "Additional power consumption";
Real Cost(unit = "$/year") "Additional power cost";
//=======================================================
//Parameter section
parameter Real COP_R = 1.3  "Coefficient of performance of refrigerator";
parameter Real n(unit = "days/year") = 365 "Number of days in a year";
parameter Real h(unit = "hrs/sec") = 24 "Number of hours in a day";
parameter Real Q_ref(unit = "W") = 40 "Power consumed by light in refrigerator in W";
parameter Real N(unit = "times/day") = 20 "Assumtion of door opening per day";
parameter Real t_1(unit = "sec/time") = 30 "Assumtion of door opening time in seconds per one time of opening";
parameter Real C(unit = "$/kWh") = 0.08 "Unit cost";
//=======================================================
//Equation section
equation
W_ref = Q_ref/COP_R;
W_total = W_ref + Q_ref;
t = n*h;
t_2 = ((N*t_1)/3600)*n;
//3600 is divided to convert seconds to hours
t_3 = t - t_2;
P = (W_total/1000) * t_3;
//1000 is divided to convert W to kW
Cost = P*C;
//=======================================================
end Ex6_8;