// Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.12, Page No: 364
//Title: Reversible steady flow work
//================================================================
package Ex7_12
  class Ex7_12_a
  //=================================================================
  //Variable Section
  Real W_rev_in(unit = "kJ/Kg") "compressor work input required to compress steam at saturated liquid condition";
  //=================================================================
  // Parameter Section
  parameter Real P1(unit = "kPa ") = 100 " intial presure of steam";
  parameter Real P2(unit = "kPa ") = 1000 " final presure of steam";
  parameter Real V(unit ="m3/Kg") = 0.001043 " specific volume of steam at saturated liquid condition";
  //=================================================================
  // Equation Section
  equation
  W_rev_in = V*(P2-P1);
  end Ex7_12_a;

  class Ex7_12_b
  //===============================================================
  //Variable Section
  Real W_rev_in(unit = "kJ/Kg") " compressor work input required to compress steam at saturated Vapor condition ";
  //===============================================================
  // Parameter Section
  parameter Real h1(unit = "kJ/Kg") = 2675 " Enthalpy at 100kpa ";
  parameter Real h2(unit = "kJ/Kg") = 3194.5 " Enthalpy at 1000kpa ";
  //===============================================================
  // Equation Section
  equation
  W_rev_in = h2-h1;
  end Ex7_12_b;
end Ex7_12;
