//===================================================
//Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.15, Page No: 374
//Title: Isentropic efficiencies of compressors and pumps
//===================================================
class Ex7_15
//=================================================
//Variable Section
Real T2_a(unit = "K") " the exit temperature of air ";
Real h2_a(unit = "kJ/Kg") " The enthalpy of the air for finding exit temperature ";
Real Pr2;
Real Wa_in(unit = "kW") "Required power input";
//=================================================
//Parameter Section 
parameter Real Pr1 = 1.1584 "Value is taken from table A-17 at T1";
parameter Real P1(unit = "kPa ") = 100 " inlet pressure of air";
parameter Real P2(unit = "kPa ") = 800 " oulet pressure of air";
parameter Real T1(unit = "deg.C") = 12 " inlet temperature ";
parameter Real h1(unit = "kJ/Kg") = 285.14 " The enthalpy of the air at the start of the isentropic compression process ";
parameter Real h2(unit = "kJ/Kg") = 517.05 " The enthalpy of the air at the end of the isentropic compression process at Pr2";
parameter Real eta_c = 0.80 " isentropic Efficiency ";
parameter Real m(unit = "Kg/s") = 0.2 " mass flow rate ";
//==================================================
//Equation Section
equation
Pr2 = Pr1*(P2/P1);
h2_a = ((h2-h1)/eta_c)+h1;
T2_a = 569.5;
//Note = T can be found using h2a from relation from table A-17
Wa_in = m*(h2_a - h1);
end Ex7_15;