//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.13, Page No: 453
//Title : Second law efficiency
 //=======================================================
package Ex8_13
  class Ex8_13_a
    //=======================================================
    //Variable section
    Real T_f(unit = "deg.C") "Final equilibrium temperature";
    //=======================================================
    //Parameter section
    parameter Real T_i_iron(unit = "deg.C") = 350 "Temperature of iron";
    parameter Real T_i_water(unit = "deg.C") = 30 "Temperature of water";
    parameter Real m_iron(unit = "Kg") = 5 "Weight of iron";
    parameter Real m_water(unit = "Kg") = 100 "Weight of water";
    //parameter Real To(unit = "deg.C") = 70 "Final equilibrium temperature";
    parameter Real Cp_iron(unit = "kJ/Kg.deg.C") = 0.45 "Specific heat of iron";
    parameter Real Cp_water(unit = "kJ/Kg.deg.C") = 4.18 "Specific heat of water";
    //=======================================================
    //Equation section
  equation
    T_f = ((m_water * Cp_water * T_i_water)+ (m_iron * Cp_iron * T_i_iron)) / ((m_water * Cp_water) + (m_iron * Cp_iron));
//=======================================================
  end Ex8_13_a;

  class Ex8_13_b
   //=======================================================
    //Variable section
    Real X_1_iron(unit = "kJ") "Energy at initial state";
  Real X_1_water(unit = "kJ") "Energy at initial state";
  Real X_1_total(unit = "kJ") "Total energy at initial state";
  Real X_2_iron(unit = "kJ") "Energy at final state";
  Real X_2_water(unit = "kJ") "Energy at final state";
  Real X_2_total(unit = "kJ") "Total energy at final state";
    //=======================================================
    //Parameter section
    parameter Real To(unit = "deg.C") = 20 "Surrounding temperature";
    parameter Real T_i_iron(unit = "deg.C") = 350 "Temperature of iron";
    parameter Real T_i_water(unit = "deg.C") = 30 "Temperature of water";
    parameter Real m_iron(unit = "Kg") = 5 "Weight of iron";
    parameter Real m_water(unit = "Kg") = 100 "Weight of water";
    parameter Real Cp_iron(unit = "kJ/Kg.deg.C") = 0.45 "Specific heat of iron";
    parameter Real Cp_water(unit = "kJ/Kg.deg.C") = 4.18 "Specific heat of water";
    parameter Real T_f(unit = "deg.C") = 31.7 "Equilibrium temperature";
    //=======================================================
    //Library section
    extends Modelica.Math;
    //=======================================================
    //Equation section
  equation
  X_1_iron = (m_iron*Cp_iron*(((T_i_iron+273)-(To+273))-((To+273)*log((T_i_iron+273)/(To+273)))));
  X_1_water = (m_water*Cp_water*(((T_i_water+273)-(To+273))-((To+273)*log((T_i_water+273)/(To+273)))));
  X_1_total = X_1_iron + X_1_water;
  X_2_iron = (m_iron*Cp_iron*(((T_f+273)-(To+273))-((To+273)*log((T_f+273)/(To+273)))));
  X_2_water = (m_water*Cp_water*(((T_f+273)-(To+273))-((To+273)*log((T_f+273)/(To+273)))));
  X_2_total = X_2_iron + X_2_water;
  //=======================================================
  end Ex8_13_b;

  class Ex8_13_c
  //=======================================================
  //Variable section
  Real X_destroyed(unit = "kJ") "Wasted work potential";
    //=======================================================
    //Parameter section
   parameter Real X_1(unit = "kJ") = 315  "Total energy at initial state";
  parameter Real X_2(unit = "kJ") = 95.6 "Total energy at final state";
    //=======================================================
    //Equation section
  equation
  X_destroyed = X_1 - X_2;
  //=======================================================
  end Ex8_13_c;
end Ex8_13;
