//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.17, Page No: 463
//Title : Second law efficiency of steady flow devices
 //=======================================================
model Ex8_17
//=======================================================
  //Variable section
    Real m2(unit = "Kg") "Final mass of air";
    Real phi_2;
    Real W_rev_in(unit = "kJ") "Reversible work in kJ";
    Real W_rev_in_1(unit = "MJ") "Reversible work in MJ";
  //=======================================================
  //Parameter section
  parameter Real P2(unit = "kPa") = 1000 "Pressure of compressed air in kPa";
  parameter Real V(unit = "m3") = 200 "Volume of tank";
  parameter Real R(unit = "kPa.m3/Kg.K") = 0.287 "Universal gas constsnt";
  parameter Real T2(unit = "deg.C") = 27 "Temperature";
   parameter Real To(unit = "deg.C") = 27 "Temperature of heat loss to surrounding air";
  parameter Real Po(unit = "kPa") = 100 "Pressure at intial state";
   //=======================================================
   //Library section
   extends Modelica.Math;
   //=======================================================
  //Equation section
equation
m2 = (P2*V)/(R*(T2+273));
phi_2 = R*(To+273)*((log(P2/Po))+(Po/P2)-1);
W_rev_in = m2*phi_2;
W_rev_in_1 = W_rev_in/1000;
//460 is added to convert deg.C to K
//1000 is divided to conevrt kJ to MJ
//=======================================================

end Ex8_17;