//======================================================
//Thermodynamics - An Engineering approach
//Chapter-09, Gas power cycles
//Exercise: 9.2, Page No: 498
//Title : Otto cycle: The ideal cycle for spark-ignition engines
 //=======================================================
package Ex9_2
  model Ex9_2_a
  //=======================================================
    //Variable section
      Real Vr2;
      Real T2(unit = "K") "Temperature at Vr2 from table A-17";
      Real u2(unit = "kJ/Kg") "Internal energy at Vr2 from table A-17";
      Real P2(unit = "kPa") "Pressure at point 2";
      Real u3(unit = "kJ/Kg") "Internal energy at point 3";
      Real T3(unit = "K") "Temperature at u3 from table A-17";
      Real Vr3;
       Real P3(unit = "MPa") "Pressure at point 3";
     
    //=======================================================
    //Parameter section
    parameter Real r = 8 "Compression ratio = V1/V2";
    parameter Real T1(unit = "K") = 290 "Temperature at point 1";
    parameter Real Vr1 = 676.1 "At temperature T1";
    parameter Real P1(unit = "kPa") = 100 "Pressure at point 1";
    parameter Real q_in(unit = "kJ/Kg") = 800 "Heat input"; 
    parameter Real r1 = 1;
    //=======================================================
    //Equation section
  equation
  Vr2 = Vr1/r;
  T2 = 652.4;
  u2 = 475.11;
  P2 = (P1)*(T2/T1)*r;
  q_in = u3 - u2;
  T3 = 1575.1;
  Vr3 = 6.108;
  P3 = (P2/1000)*(T3/T2)*r1;
  //1000 is divided to convert kJ to MJ
  //=======================================================
  end Ex9_2_a;

  model Ex9_2_b
  //=======================================================
    //Variable section
      Real Vr4;
      Real T4(unit = "K") "Temperature at Vr4 from table A-17";
      Real u4(unit = "kJ/Kg") "Internal energy at Vr4 from table A-17";
      Real q_out(unit = "kJ/Kg") "Heat rejection at constant volume";
      Real W_net(unit = "kJ/Kg") "Net work";
    //=======================================================
    //Parameter section
    parameter Real r = 8 "Compression ratio = V1/V2";
    parameter Real T3(unit = "K") = 1575.1 "Temperature at point 3";
    parameter Real Vr3 = 6.108 "At temperature T3";
    parameter Real u1(unit = "kJ/Kg") = 206.91 "Internal energy at temperature T1";
    parameter Real q_in(unit = "kJ/Kg") = 800 "Heat input"; 
    //=======================================================
    //Equation section
  equation
  Vr4 = r*Vr3;
  T4 = 795.6;
  u4 = 588.74;
  q_out = u4-u1;
  W_net = q_in - q_out;
  //=======================================================
  end Ex9_2_b;

  model Ex9_2_c
  //=======================================================
    //Variable section
      Real eta_th "Thermal efficiency";
      Real eta_th_1(unit = "%") "Thermal efficiency";   
      Real eta_otto;
      Real eta_otto_1; 
     //=======================================================
    //Parameter section
    parameter Real W_net(unit = "kJ/Kg") = 418.17 "Net work";
    parameter Real q_in(unit = "kJ/Kg") = 800 "Heat input"; 
    parameter Real k = 1.4 "For isentropic process";
    parameter Real r = 8 "Compression ratio = V1/V2";
    //=======================================================
    //Equation section
  equation
  eta_th = W_net/q_in;
  eta_th_1 = eta_th*100;
  eta_otto = 1-(r^(1-k));
  eta_otto_1 = eta_otto*100;
  //=======================================================
  end Ex9_2_c;

  model Ex9_2_d
  //=======================================================
    //Variable section
      Real v1(unit ="m3/Kg") "Specific volume";
      Real MEP(unit = "kPa") "Mean effective pressure";
    //=======================================================
    //Parameter section
    parameter Real r = 8 "Compression ratio = V1/V2";
    parameter Real T1(unit = "K") = 290 "Temperature at point 3";
    parameter Real R(unit = "kPa.m3/(Kg.K)") = 0.287 "Universal gas constant";
    parameter Real P1(unit = "kPa") = 100 "Internal energy at temperature T1";
    parameter Real W_net(unit = "kJ/Kg") = 418.17 "Net work";
    //=======================================================
    //Equation section
  equation
  v1 = (R*T1)/P1;
  MEP = W_net/(v1*(1-(1/r)));
  //=======================================================
  end Ex9_2_d;
end Ex9_2;
