//======================================================
//Thermodynamics - An Engineering approach
//Chapter-09, Gas power cycles
//Exercise: 9.5, Page No: 511
//Title : Developement of gas turbines
 //=======================================================
package Ex9_5
  model Ex9_5_a
  //=======================================================
  //Variable section
  Real Pr2; 
  Real Pr4;
  Real T4(unit = "K") "Temperature for process 3-4";
  Real h4(unit = "kJ/Kg") "Enthalpy of process 3-4";   
    //=======================================================
    //Parameter section
    parameter Real r = 8 "Compression ratio = P1/P2";
    parameter Real T3(unit = "K") = 1300 "Temperature for process 2-3";
    parameter Real T1(unit = "K") = 300 "Temperature at point 1";
    parameter Real Pr1 = 1.386 "Pr1 value at temperature T1";
    parameter Real h1(unit = "kJ/Kg") = 300.19 "Enthalpy at temperature T1";
    parameter Real V1(unit = "in3") = 117 "Volume for process 1-2";
    parameter Real P1(unit = "psia") = 14.7 "Pressure at process 1-2";
    parameter Real h2(unit = "kJ/Kg") = 544.35 "Enthalpy at Pr2";
    parameter Real h3(unit = "kJ/Kg") = 1395.94 "Enthalpy at process 2-3 for an isentropic compression of an ideal gas";
    parameter Real T2(unit = "K") = 540 "Temperature for process 1-2 i.e., isentropic compression of an ideal gas";
   parameter Real Pr3 = 330.9 "At temperature T3";
    parameter Real k = 1.4 "k value for isentropic process";
    //=======================================================
    //Equation section
  equation
  Pr2 = r*Pr1;
  Pr4 = (1/r)*Pr3;
  T4 = 770;
  h4 = 789.37;
  //=======================================================
  end Ex9_5_a;

  model Ex9_5_b
  //=======================================================
  //Variable section
  Real W_comp_in(unit = "kJ/Kg") "Work input to the compressor"; 
  Real W_turbine_out(unit = "kJ/Kg") "Work output of the turbine";
  Real r_bw;
  Real r_bw_1(unit = "%");   
    //=======================================================
    //Parameter section
    parameter Real h1(unit = "kJ/Kg") = 300.19 "Enthalpy at temperature T1";
    parameter Real h2(unit = "kJ/Kg") = 544.35 "Enthalpy at Pr2";
    parameter Real h3(unit = "kJ/Kg") = 1395.94 "Enthalpy at process 2-3 for an isentropic compression of an ideal gas";
    parameter Real h4(unit = "kJ/Kg") = 789.37 "Enthalpy at process 3-4 for an isentropic compression of an ideal gas";
    //=======================================================
    //Equation section
  equation
  W_comp_in = h2 - h1;
  W_turbine_out = h3 - h4;
  r_bw = W_comp_in/W_turbine_out;
  r_bw_1 = r_bw*100;
  //=======================================================
  end Ex9_5_b;

  model Ex9_5_c
  //=======================================================
  //Variable section
  
  Real q_in(unit = "kJ/Kg") "Heat input";
  Real q_out(unit = "kJ/Kg") "Heat output";
  Real W_net(unit = "kJ/Kg") "Net work";
  Real eta_th;
  Real eta_th1(unit = "%");
  Real eta_th_1;
  Real eta_th_Brayton;
    //=======================================================
    //Parameter section
    parameter Real h1(unit = "kJ/Kg") = 300.19 "Enthalpy at temperature T1";
    parameter Real h2(unit = "kJ/Kg") = 544.35 "Enthalpy at Pr2";
    parameter Real h3(unit = "kJ/Kg") = 1395.94 "Enthalpy at process 2-3 for an isentropic compression of an ideal gas";
    parameter Real h4(unit = "kJ/Kg") = 789.37 "Enthalpy at process 3-4 for an isentropic compression of an ideal gas";
    parameter Real r = 8;
    parameter Real k = 1.4 "Isentropic compression ratio";
   parameter Real W_comp_in(unit = "kJ/Kg") = 244.16 "Work input to the compressor"; 
  parameter Real W_turbine_out(unit = "kJ/Kg") = 606.6 "Work output of the turbine";
    //=======================================================
    //Equation section
  equation
  q_in = h3 - h2;
  W_net = W_turbine_out - W_comp_in;
  eta_th = W_net/q_in;
  eta_th1 = eta_th*100;
  q_out = h4 - h1;
  eta_th_1 = 1 - q_out/q_in;
  eta_th_Brayton = 1-(1/(r^((k-1)/k)));
  //=======================================================
  end Ex9_5_c;
end Ex9_5;
