//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-1:Mathematical Procedures
//Example 1.2; Page 3
//Title: Finding solution of 2 independent equation
//==================================

model Ex1_2
//==================================
//Parameter Section
parameter Real xh(unit=" ")=5 "initial molal ratio of H2O and Carbon monooxide";
parameter Real Tr(unit="K")=1100 "Reaction Temperature";
parameter Real Pr(unit="atm")=10 "Reaction Pressure";

//==================================
//Variable Section
Real x(unit="moles") "moles of H2O converted per 6 moles of feed, according to water gas reaction 
H2O + CO --> CO2 + H2";
Real y(unit="moles") "moles of CO converted, per 6 moles of fedd, according to reaction 
C + CO2 --> 2CO";

//==================================
//Equation Section
equation
((x-y)*x)/((1-x+2*y)*(5-x))=0.9442;
((1-x+2*y)^2)/((x-y)*(6+y))=1.2201;
end Ex1_2;
