//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-1:Mathematical Procedures
//Example 1.3; Page 4
//Title: Finding heat absorbed by stepwise integration
//==================================
model Ex1_3
//parameter variables
parameter Real cp[10](unit="J/K")={2.066 ,2.851 ,3.496 ,4.03 ,4.43 ,4.75 ,4.98 ,5.14 ,5.27 ,5.42 } "Heat Capacity at different Temperatures";
parameter Real T[10](unit="K")={298.16,400,500,600,700,800,900,1000,1100,1200} "Temperatures at which Heat capacity is given";
//variables
Real q(unit="J") "Amount of heat absorbed";
Real sum(unit="J") "dummy variable";
//algorithm
algorithm
sum:=sum+(T[2]-T[1])*(cp[1]+cp[2])/2;
for i in 2:9 loop
sum:=sum+(T[i+1]-T[i])*(cp[i]+cp[i+1])/2;
end for;
q:=sum;
end Ex1_3;
