//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-1:Mathematical Procedures
//Example 1.8; Page 19
//Title: Conversion of equation
model Ex1_8
//parameter section
parameter Real a(unit="(lb^(0.2)*(in^(0.2))*(sec^(0.8))*)/(hr*(ft^(0.4)))")=16.6 "constant of proportionality required for dimensional equality";
parameter Real c1(unit=" ")=1/3.966 "Conversion factor from Btu to kcal";
parameter Real c2(unit=" ")=3600 "Conversion factor from hr to sec";
parameter Real c3(unit=" ")=12*2.54 "Conversion factor from ft to cm";
parameter Real c4(unit=" ")=5/9 "Conversion factor from F to C";
parameter Real c5(unit=" ")=2.205 "Conversion factor from kg to lb";
parameter Real c6(unit=" ")=2.54 "Conversion factor from in to cm";
parameter Real c7(unit=" ")=3.281 "Conversion factor from m to ft";
//variable section
Real cp(unit=" ") "Conversion factor from Btu/((lb)(F)) to kcal/((kg)(C))";
Real D(unit=" ") "Conversion factor from in to cm";
Real G(unit=" ") "Conversion factor from lb/((sec)(ft^2)) to kg/((sec)(m^2))";
Real h(unit=" ") "Conversion factor from Btu/((hr)(ft^2)(F)) to kcal/((hr)(m^2)(C))";
Real an(unit="(kg^(0.2)*cm^(0.2)*sec^(0.8))/(hr*m^(0.4)") "new constant of proportionlaity" ;
//equation section
equation
cp=(c1*c5)/(c4);
D=c6;
G=(1/c5)/(1/c7)^2;
h=c1/((1/c7)^2*c4);
an=a*1/(cp*G^(0.8)/(D^(0.2)*h)) "value of constant of proportionality in conversion";
end Ex1_8;
