//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-1:Mathematical Procedures
//Example 1.9; Page 21
//Title: Conversion of heat-capacity equation 
model Ex1_9
parameter Real c1(unit="g-cal/((g-mole)(K))")=6.339 "First constant of heat-cpacity equation";
parameter Real c2(unit="g-cal/g-mole")=10.14*10^(-3) "Second constant of heat-capacity equation";
parameter Real c3(unit="(g-cal*K)/g-mole")=-3.415*10^(-6) "Third constant of heat-capacity equation";
parameter Real c4(unit=" ")=252 "Conversion factor of Btu to g-cal";
parameter Real c5(unit=" ")=453.6/44.01 "Conversion factor of lb to g-mole of CO2 where 1lb=(1/44.01)lb-mole and 1lb=453.6g thus 1lb = 453.6/44.01 g-mole";
parameter Real c6(unit=" ")=9/5 "Conversion of K to F";
//variable section
Real c7(unit="Btu/((lb)(F))") "First constant of new equation";
Real c8(unit="Btu/((lb))") "Second constant of new equation";
Real c9(unit="(Btu*F)/(lb)") "Third constant of new equation";
Real c10(unit=" ") "Conversion Factor of cp";
//equation section
equation
c10=(c5)/(c4*c6);
c7=c10*(c1+(c2*459.69/1.8)+c3*(459.69/1.8)^2) "The constant term after rearranging terms and using T(in K)=(T(in F)+459.69)/(1.8)";
c8=c10*((c2/1.8)+(c3*2*459.69)/(1.8^2)) "The term with Temp power 1(i.e. T) after rearranging terms and using T(in K)=(T(in F)+459.69)/(1.8)";
c9=c10*(c3/(1.8^2)) "The term with temp power 2(i.e. T^2) after rearranging terms and using T(in K)=(T(in F)+459.69)/(1.8)";
end Ex1_9;
