//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-2:Stoichometric and composition Relationships
//Example 2.5; Page 37
//Title: Expressing composition in w/w% from mole per cent
model Ex2_5
//parameter section
parameter Real ba(unit="g")=100 "basis i.e. moles of solution";
parameter Real xN(unit=" ")=25 "mole percent of Naphthalene in Benzene";
parameter Real MN(unit="g")=128.1 "Molar mass of Naphthalene";
parameter Real MB(unit="g")=78.1 "Molar mass of Benzene";
//variable section
Real wN(unit="g") "weight of Naphthalene";
Real wB(unit="g") "weight of Benzene"; 
Real nN(unit="moles") "number of moles of Naphthalene";
Real nB(unit="moles") "number of moles of Benzene";
Real yN(unit=" ") "w/w% of Naphthalene in Benzene solution"; 
Real yB(unit=" ") "w/w% of Benzene in Benzene solution"; 
//equation section
equation
nN=ba*xN/100;
nB=ba*(1-xN/100);
wN=nN*MN;
wB=nB*MB;
yN=(wN/(wN+wB))*100;
yB=(wB/(wN+wB))*100;
end Ex2_5;
