//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-3:Behavior of Ideal Gases
  //Example 3.7; Page 59
  //Title: Finding density of mixture
model Ex3_7
//parameter section
parameter Real ba(unit="lb")=1 "Basis of calculation";
parameter Real P(unit="inHg")=29 "Pressure of mixture";
parameter Real Psc(unit="inHg")=29.92 "Pressure of mixture at standard conditions";
parameter Real Tsc(unit="C")=0 "Temperature of mixture at standard conditions";
parameter Real T(unit="C")=30 "Temperature of mixture";
parameter Real wH(unit=" ")=11.1 "w/w% of H2 in mixture";
parameter Real Vsc(unit="cu ft")=359 "Volume of any ideal gas at standard conditions";
//variable section
Real mH2(unit="lb") "mass of H2 in mixture";
Real mO2(unit="lb") "mass of O2 in mixture";
Real nH2(unit="lb-mole") "moles of H2 in mixture";
Real nO2(unit="lb-mole") "moles of O2 in mixture";
Real nt(unit="lb-mole") "Total moles in mixture";
Real vsc(unit="cu ft") "volume occupied by mixture at standard conditions";
Real v(unit="cu ft") "volume occupied by mixture";
Real d(unit="lb/cuft") "density of mixture";
//equation section
equation
mH2=ba*wH/100;
mO2=ba*(1-wH/100);
nH2=mH2/2 "2lb is the molar mass of H2";
nO2=mO2/32 "32lb is the molar mass of O2";
nt=nH2+nO2;
vsc=Vsc*nt;
v=vsc*Psc/P*((T+273.15)/(Tsc+273.15));
d=ba/v;
end Ex3_7;
