//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-4:Vapor Pressures
  //Example 4.1; Page 79
//Title: Calculating Vapor Pressure of ethyl ether at 20 and 35 degree C 
model Ex4_1
//import section
import Modelica.Math.*;
//parameter section
parameter Real T0(unit="C")=0 "Temperature at which vapor pressure of ethyl ether is known";
parameter Real T1(unit="C")=20 "Temperature at which vapor pressure of ethyl ether is to be calculated";
parameter Real T2(unit="C")=35 "Temperature at which vapor pressure of ethyl ether is to be calculated";
parameter Real P0(unit="mmHg")=185 "Pressure at 0 degree C";
parameter Real LV(unit="cal/g")=92.5 "Latent Heat of vaporization per gram of ethyl ether at 0 degree C";
parameter Real ME(unit="g")=74 "Molar mass of ethyl ether";
parameter Real R(unit="cal/((g-mole)*K)")=1.99 "Universal gas constant";
//variable section
Real La(unit="cal/g-mole") "Latent Heat of vaporization in cal/g-mole";
Real P1(unit="mmHg") "Pressure at 20 degree C";
Real P2(unit="mmHg") "Pressure at 35 degree C";
//equation section
equation
/*Assupmtion: Latent heat of vaporization does not change significantly in small temperature range*/
La=LV*ME;
log(P1/P0)=(La/R)*((1/(T0+273.15))-(1/(T1+273.15)));
log(P2/P0)=(La/R)*((1/(T0+273.15))-(1/(T2+273.15)));
end Ex4_1;
