//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
//Chapter-4:Vapor Pressures
//Example 4.8; Page 100
package Ex4_8
        //Title: Calculating weight of steam required per pound acid at 200 degree C and 740mmHg atmospheric pressure

  model Ex4_8_a
    //parameter section
    parameter Real rss(unit = " ") = 0.8 "relative saturation of steam with myristic acid";
    parameter Real tP(unit = "mmHg") = 740 "Atmospheric pressure";
    parameter Real mP(unit = "mmHg") = 14.5 "Vapor pressure of myristic acid at 200 degree C";
    parameter Real MM(unit = "g") = 228 "molar mass of myristic acid";
    parameter Real MS(unit = "g") = 18 "molar mass of steam";
    //variable section
    Real mp(unit = "mmHg") "partial vapor pressure of myristic acid";
    Real sp(unit = "mmHg") "partial vapor pressure of steam";
    Real mm(unit = "lb-moles") "amount of myristic acid in mixture";
    Real ms(unit = "lb-moles") "amount of steam in mixture";
    Real ws(unit = "lb") "amount of steam";
    Real wm(unit = "lb") "amount of myristic acid";
    Real wws(unit = " ") "amount of steam required per pound of acid";
    //equation section
  equation
    mp = rss * mP;
    sp = tP - mp;
    mm = mp / tP;
    ms = sp / tP;
    ws = ms * MS;
    wm = mm * MM;
    wws = ws / wm;
  end Ex4_8_a;


  //Title: Find weight of steam per pound acid if 26inHg vacuum is maintained in apparatus
  model Ex4_8_b
  //parameter section
  parameter Real rss(unit = " ") = 0.8 "relative saturation of steam with myristic acid";
    parameter Real tP(unit = "mmHg") = 740 "Atmospheric pressure";
    parameter Real mP(unit = "mmHg") = 14.5 "Vapor pressure of myristic acid at 200 degree C";
    parameter Real MM(unit = "g") = 228 "molar mass of myristic acid";
    parameter Real MS(unit = "g") = 18 "molar mass of steam";
  parameter Real vP(unit="in.Hg")=26 "Vacuum to be maintained in apparatus";
  parameter Real c1(unit=" ")=25.4 "conversion factor from in.hg to mmHg; 1in.Hg=25.4mmHg";
  //variable section
  Real aP(unit="mmHg") "Pressure inside apparatus";
  Real mp(unit = "mmHg") "partial vapor pressure of myristic acid";
    Real sp(unit = "mmHg") "partial vapor pressure of steam";
    Real mm(unit = "lb-moles") "amount of myristic acid in mixture";
    Real ms(unit = "lb-moles") "amount of steam in mixture";
    Real ws(unit = "lb") "amount of steam";
    Real wm(unit = "lb") "amount of myristic acid";
    Real wws(unit = " ") "amount of steam required per pound of acid";
     //equation section
  equation
  aP=tP-vP*c1;
    mp = rss * mP;
    sp = aP - mp;
    mm = mp / aP;
    ms = sp / aP;
    ws = ms * MS;
    wm = mm * MM;
    wws = ws / wm;
  end Ex4_8_b;




end Ex4_8;
