//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.1; Page 145
  //Title: FInding the difference in solubilities of NaCl in water at 15 degree C and 65 degree C
model Ex6_1
//parameter section
parameter Real ba(unit="lb")=1000 "basis amount of water";
parameter Real s1(unit="lb-moles")=6.12 "Amount of NaCl soluble in 1000 lb water at 15 degree C";
parameter Real s2(unit="lb-moles")=6.37 "Amount of NaCl soluble in 1000 lb water at 65 degree C";
parameter Real MN(unit="g")=58.5 "Molar mass of NaCl";
//variable section
Real mS1(unit="lb") "mass of solution at 15 degree C";
Real mS2(unit="lb") "mass of solution at 65 degree C";
Real ms1(unit="lb") "mass of solute in 100 lb solution at 15 degree C";
Real mS(unit="lb") "final mass of solution if initial mass is 100lb";
Real ms2(unit="lb") "mass of solute in 100 lb solution at 65 degree C";
Real sd(unit="lb") "mass of NaCl that can be dissolved if solution heated from 15 to 65 degree C";
//equation section
equation
mS1=ba+MN*s1;
mS2=ba+MN*s2;
ms1=MN*s1*(100/mS1);
ms2=MN*s2*(mS/mS2);
mS=100+sd;
sd=ms2-ms1 "Error greater than 2% due to round off in book";
end Ex6_1;
