 //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.11; Page 157
  //Title: Calculating the amount of water that must be evaporated to saturate solution with one solute w/o crystallization
model Ex6_11
//parameter section
  parameter Real ba(unit = "lb") = 100 "amount of solution taken as basis";
  parameter Real cNC1(unit = " ") = 1.8 "Composition of Na2CO3 taken at 20 degree C";
  parameter Real cNS1(unit = " ") = 9.8 "Composition of Na2SO4 taken at 20 degree C";
  parameter Real MNC(unit = "g") = 106 "Molar mass of Na2CO3";
  parameter Real MNS(unit = "g") = 142 "Molar mass of Na2SO4";
  parameter Real MW(unit = "g") = 18 "Molar mass of H2O";
  parameter Real mwNCc(unit=" ")=10 "moles of H2O in one mole Na2CO3.10H2O crystal";
  parameter Real mwNSc(unit=" ")=10 "moles of H2O in one mole Na2SO4.10H2O crystal";
  parameter Real cNCs(unit = " ") = 2.8 "Composition of Na2CO3 at saturation of Na2SO4 taken at 20 degree C";
  parameter Real cNSs(unit = " ") = 15.1 "Composition of Na2SO4 at saturation of Na2SO4 taken at 20 degree C";
  //variable section
  Real awe(unit = " lb") "amount of water evaporated";
  //equation section
equation
  (cNC1/100)*ba=(cNCs/100)*(ba-awe);
end Ex6_11;
