package Ex6_14
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.14; Page 163
  //Title: calculating the volume of benzene to be added and percent recovery of picric acid

  model Ex6_14_a
    //parameter section
    parameter Real ba(unit = "L") = 1 "amount of aqueous solution initially";
    parameter Real cpai(unit = "g-mole/L") = 0.2 "Concentration of picric acid in aqueous solution initially";
    parameter Real CE(unit = "g-mole/L") = 0.02 "Concentration of extract solution";
    parameter Real K(unit = " ") = 0.505 "value of K corresponding to given value of concentration of extract solution";
    //variable section
    Real CR(unit = "g-mole/L") "concentration of raffinate solution";
    Real np(unit = "g-moles") "moles of picric acid";
    Real V(unit = "L") "amount of benzene needed";
    //equation section
  equation
    CR = CE / K;
    np = ba * cpai;
    np = CE * V + CR * ba;
  end Ex6_14_a;

  model Ex6_14_b
  extends Ex6_14_a;
  //variable section
  Real apb(unit="g-moles") "amount of picric acid in benzene";
  Real pr(unit=" ") "percent recovery of picric acid";
  //equation section
  equation
  apb=V*CE;
  pr=apb/np*100;
  end Ex6_14_b;


end Ex6_14;
