//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.3; Page 147
package Ex6_3
        //Title: Calculating % saturation of solution

  model Ex6_3_a
    //parameter section
    parameter Real ba1(unit = "lb") = 100 "amount of solution as basis";
    parameter Real pN1(unit = " ") = 49 "w/w% of NaNO3 initially in solution 40 degree C";
    parameter Real psN1(unit = " ") = 51.4 "w/w% of NaNO3 at saturation at 40 degree C";
    //variable section
    Real psN(unit = " ") "% saturation of solution";
    //equation section
  equation
    psN = ba1 * (pN1 / 100) / (ba1 * (1 - pN1 / 100)) / (ba1 * (psN1 / 100) / (ba1 * (1 - psN1 / 100))) * 100;
  end Ex6_3_a;

  //Title: Calculting weight of NaNO3 crystallized

  model Ex6_3_b
    //parameter section
    parameter Real ba(unit = "lb") = 1000 "amount of solution taken initially at 40 degree C as basis";
    parameter Real pN1(unit = " ") = 49 "w/w% of NaNO3 initially in solution 40 degree C";
    parameter Real psN2(unit = " ") = 44.5 "w/w% of NaNO3 saturated in solution 10 degree C";
    //variable section
    Real ims(unit = "lb") "initial amount of solute in solution";
    Real mw(unit = "lb") "amount of water in solution";
    Real fms(unit = "lb") "final mass of solution";
    Real ms(unit = "lb") "mass of solute left in solution";
    Real msc(unit = "lb") "mass of solute crystallized";
    //equation section
  equation
    ims = ba * pN1 / 100;
    mw = ba * (1 - pN1 / 100);
    fms = mw + ms;
    mw = fms * (1 - psN2 / 100);
    msc = ims - ms;
  end Ex6_3_b;

  //Title: Calculating % yield of solution
  model Ex6_3_c
  extends Ex6_3_b;
  //variable section
  Real py(unit=" ") "% yield of NaNO3 crystals";
  //equation section
  equation
  py= (msc/ims)*100;
  end Ex6_3_c;


end Ex6_3;
