//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-6:Solubility and crystallization
  //Example 6.9; Page 150
  //Title: Calculating the weight of crystals and % yield obtained by cooling
model Ex6_9
//parameter section
parameter Real ba(unit="lb")=100 "amount of initial solution taken as basis";
parameter Real sN1(unit=" ")=32.6 "percentage solubility of Na2SO4 at 40 degree C in water";
parameter Real sN2(unit=" ")=5.75 "percentage solubility of Na2SO4 at 5 degree C in water";
parameter Real wn(unit="lb-mole")=10 "lb-moles of water per lb-mole Na2SO4 in Na2SO4 crystal";
parameter Real MN(unit="g")=142 "Molar mass of Na2SO4";
parameter Real MW(unit="g")=18 "Molar mass of water";
//variable section
Real aNsi(unit="lb") "amount of Na2SO4 in solution initially";
Real aWsi(unit="lb") "amount of water in soultion initialy";
Real aNs(unit="lb") "amount of Na2SO4 in solution finally";
Real aWs(unit="lb") "amount of water in solution";
Real ac(unit="lb") "amount of crystal after crystallization";
Real MC(unit="g") "Molar mass of crystals";
Real mNi(unit="lb-moles") "amount of na2SO4 in solution initially";
Real mWi(unit="lb-moles") "amount of H2O in solution initially";
Real mc(unit="lb") "max amount of crystals possible";
Real y(unit=" ") "yield of Na2SO4 crystals";
//equation section
equation
aNsi=ba*(sN1/100);
aNs=(sN2/100)*(aNs+aWs);
aWsi=ba-aNsi;
aWs=aWsi-(aNsi-aNs)/MN*wn*MW;
ac=ba-aWs-aNs;
MC=MN+10*MW;
mNi=aNsi/MN;
mWi=aWsi/MW;
if mWi/mNi<=10 then
mc=aWsi*(MW*10+MN)/MW;
else
mc=aNsi*(MW*10+MN)/MN;
end if;
y=ac/mc*100;
end Ex6_9;
