  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-7:Material Balances
  //Example 7.1; Page 196
  //Title: calculating the weight of waste and acid required
model Ex7_1
//parameter section
parameter Real ba(unit="lb")=1000 "amount of desired mixture";
parameter Real wpHNd(unit=" ")=27 "weight percent of HNO3 in desired mixture";
parameter Real wpHSd(unit=" ")=60 "weight percent of H2SO4 in desired mixture";
parameter Real wpHNw(unit=" ")=23 "weight percent of HNO3 in waste mixture";
parameter Real wpHSw(unit=" ")=57 "weight percent of HNO3 in waste mixture";
parameter Real wpHNa(unit=" ")=90 "weight percent of HNO3 in concentrated HNO3 solution";
parameter Real wpHSa(unit=" ")=93 "weight percent of H2SO4 in concentrated H2SO4 solution";
//variable section
Real aws(unit="lb") "amount of waste solution used to get 1000lb desired solution";
Real aHNsa(unit="lb") "amount of HNO3 solution added";
Real aHSsa(unit="lb") "amount of H2SO4 solution added";
//equation section
equation
(wpHNd/100)*ba=aws*(wpHNw/100)+(wpHNa/100)*aHNsa;
(wpHSd/100)*ba=aws*(wpHSw/100)+(wpHSa/100)*aHSsa;
(100-wpHNd-wpHSd)/100*ba=aws*((100-wpHNw-wpHSw)/100)+(100-wpHNa)/100*aHNsa+(100-wpHSa)/100*aHSsa;
end Ex7_1;
