//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-7:Material Balances
  //Example 7.2; Page 198
  //Title: Calculating the composition and weight of gaseous products
model Ex7_2
//parameter section
parameter Real ba(unit="lb-moles")=100 "amount of gas burned";
parameter Real cCOi(unit=" ")=28 "composition of CO in initial gas mixture";
parameter Real cCO2i(unit=" ")=3.5 "composition of CO2 in initial gas mixture";
parameter Real cOi(unit=" ")=0.5 "composition of O2 in initial gas mixture";
parameter Real cNi(unit=" ")=68 "composition of N2 in initial gas mixture";
parameter Real MCO(unit="g")=28 "Molar mass of CO";
parameter Real MCO2(unit="g")=44 "Molar mass of CO2";
parameter Real MO(unit="g")=32 "Molar mass of O2";
parameter Real MN(unit="g")=28.2 "Molar mass of N2";
parameter Real Orcc(unit="lb")=16 "amount of O2 requred for complete combustion of 1lb-mole of CO";
parameter Real eOr(unit=" ")=20 "percent excess O2 required";
parameter Real pch(unit=" ")=98 "percent combustion taking place";
parameter Real paO(unit=" ")=21 "percent of air O2";
parameter Real MA(unit="g")=29 "Molar mass of dry air";
//variable section
Real imCO(unit="lb") "initial mass of CO";
Real imCO2(unit="lb") "initial mass of CO2";
Real imO(unit="lb") "initial mass of O2";
Real imN(unit="lb") "initial mass of N2";
Real aOcc(unit="lb") "amount of O2 for complete combustion";
Real aOacc(unit="lb") "amount of O2 from air for complete combustion";
Real aOr(unit="lb") "amount of O2 required";
Real aar(unit="lb") "amount of air required";
Real aCOc(unit="lb") "amount of CO undergone combustion";
Real aCO2p(unit="lb") "amount of CO2 produced";
Real aOc(unit="lb") "amount of O2 undergone combustion";
Real aCOr(unit="lb") "amount of CO remianing";
Real aCO2r(unit="lb") "amount of CO2 remaining";
Real aOre(unit="lb") "amount of O2 remaining";
Real aNr(unit="lb") "amount of N2 remaining";
Real tfm(unit="lb-moles") "total final moles";
Real pCO(unit=" ") "percent composition of CO";
Real pCO2(unit=" ") "percent composition of CO2";
Real pO(unit=" ") "percent composition of O2";
Real pN(unit=" ") "percent composition of N2";
Real w(unit="lb") "amount of final gas per 100lb producer gas";
//equation section
equation
imCO=(cCOi/100)*ba*MCO;
imCO2=(cCO2i/100)*ba*MCO2;
imO=(cOi/100)*ba*MO;
imN=(cNi/100)*ba*MN;
aOcc=(Orcc/MCO)*imCO;
aOacc=aOcc-imO;
aOr=aOacc*(1+eOr/100);
aOr/MO=(paO/100)*aar/MA;
aCOc=imCO*(pch/100);
aCO2p=aCOc*MCO2/MCO;
aOc=aCOc*MO/MCO*cOi;
aCOr=imCO-aCOc;
aCO2r=imCO2+aCO2p;
aOre=aOr+imO-aOc;
aNr=imN+(aar-aOr);
tfm=aCOr/MCO+aCO2r/MCO2+aOre/MO+aNr/MN;
pCO=(aCOr/MCO)/tfm*100;
pCO2=(aCO2r/MCO2)/tfm*100;
pO=(aOre/MO)/tfm*100;
pN=(aNr/MN)/tfm*100;
w=(aCOr+aCO2r+aOre+aNr)/(imCO+imCO2+imO+imN)*100;
end Ex7_2;
