//O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-7:Material Balances
  //Example 7.6; Page 211
  //Title: calculating the amount of NaCl crystallized and amount of water evaporated from evaporator III
model Ex7_6
//parameter section
parameter Real fb(unit="tons")=29 "amount of fresh brine entering as fresh feed";
parameter Real pNs(unit=" ")=26 "percent NaCl in solution";
parameter Real aweI(unit="tons")=12.6 "amount of water evaporated from evaporator I";
parameter Real aweII(unit="tons")=11.7 "amount of water evaporated from evaporator II";
parameter Real d1c(unit="cu ft")=12.1 "1 inch drop in brine solution corresponds to 12.1 cuft";
parameter Real dI(unit="in.")=10 "drop in brine solution in evaporator I";
parameter Real dII(unit="in.")=12 "drop in brine solution in evaporator II";
parameter Real dIII(unit="in.")=8 "drop in brine solution in evaporator III";
parameter Real sgN(unit=" ")=2.15 "specific gravity of NaCl crystals";
parameter Real sgBI(unit=" ")=1.14 "specific gravity of brine solution in evaporator I";
parameter Real sgBII(unit=" ")=1.145 "specific gravity of brine solution in evaporator II";
parameter Real sgBIII(unit=" ")=1.15 "specific gravity of brine solution in evaporator III";
parameter Real c1(unit="lb/cu.ft")=62.4 "density of water in pounds per cuft";
parameter Real sNI(unit=" ")=29 "solubility of NaCl % by weight in evaporator I";
parameter Real sNII(unit=" ")=27.9 "solubility of NaCl % by weight in evaporator II";
parameter Real sNIII(unit=" ")=27 "solubility of NaCl % by weight in evaporator III";

//variable section
Real bdI(unit="ton") "amount of brine displaced per ton NaCl crystallized in evaporator I";
Real scI(unit="ton") "amount of salt crystallized in evaporator I";
Real bdII(unit="ton") "amount of brine displaced per ton NaCl crystallized in evaporator II";
Real scII(unit="ton") "amount of salt crystallized in evaporator II";
Real bdIII(unit="ton") "amount of brine displaced per ton NaCl crystallized in evaporator III";
Real scIII(unit="ton") "amount of salt crystallized in evaporator III";
Real tdbI(unit="tons") "total depletion of brine in evaporator I";
Real tdbII(unit="tons") "total depletion of brine in evaporator II";
Real tdbIII(unit="tons") "total depletion of brine in evaporator III";
Real aweIII(unit="tons") "water evaporated from evaporator III";
Real stbdI(unit="ton") "salt in total brine depletion in evaporator I";
Real stbdII(unit="ton") "salt in total brine depletion in evaporator II";
Real stbdIII(unit="ton") "salt in total brine depletion in evaporator III";
Real wtbdI(unit="ton") "water in total brine depletion in evaporator I";
Real wtbdII(unit="ton") "water in total brine depletion in evaporator II";
Real wtbdIII(unit="ton") "water in total brine depletion in evaporator III";
Real abItII(unit="ton") "amount of brine going from evaporator I to II";
Real abIItIII(unit="ton") "amount of brine going from evaporator II to III";

//equation section
equation
bdI=sgBI/sgN;
bdII=sgBII/sgN;
bdIII=sgBIII/sgN;
tdbI=bdI*scI+dI*d1c*c1*sgBI/2000;
tdbII=bdII*scII+dII*d1c*c1*sgBII/2000;
tdbIII=bdIII*scIII+dIII*d1c*c1*sgBIII/2000;
stbdI=sNI/100*tdbI;
stbdII=sNII/100*tdbII;
stbdIII=sNIII/100*tdbIII;
wtbdI=(1-sNI/100)*tdbI;
wtbdII=(1-sNII/100)*tdbII;
wtbdIII=(1-sNIII/100)*tdbIII;
fb*(1-pNs/100)+wtbdI+wtbdII+wtbdIII=aweI+aweII+aweIII "overall water balance";
fb*(pNs/100)+stbdI=scI+sNI/100*abItII "salt balance from evaporator I to II";
fb*(1-pNs/100)+wtbdI=aweI+(1-sNI/100)*abItII "water balance from evaporator I to II";
abItII*(sNI/100)+stbdII=scII+sNII/100*abIItIII "salt balance from evaporator II to III";
abItII*(1-sNI/100)+wtbdII=aweII+(1-sNII/100)*abIItIII "water balance from evaporator II to III";
abIItIII*(sNII/100)+stbdIII=scIII "salt balance from evaporator II to III";

end Ex7_6;
