package Ex9_12
  //O.A. Hougen, K.M. Watson, R.A. Ragatz; Chemical Process Principles Part 1; Second edition
  //Chapter-9:Thermochemistry
  //Example 9.12; Page 330
  //Title: Finding temperature of final mixture

  model Ex9_12_a
    //parameter section
    parameter Real aC(unit = "lb") = 200 "amount of anhydrous CaCl2 ";
    parameter Real aCs(unit = "lb") = 500 "amount of 20% CaCl2 solution";
    parameter Real pS(unit = " ") = 20 "concentration of CaCl2 solution";
    parameter Real EC(unit = "Btu/lb") = 12 "Enthalpy of anhydrous CaCl2 per pound";
    parameter Real ECs(unit = "Btu/lb") = -15 "Enthalpy of 20% CaCl2 solution per pound solution";
    //variable section
    Real fc(unit = " ") "Final concentration of CaCl2 solution";
    Real fE(unit = "Btu/lb") "Final enthalpy per pound solution";
    //equation section
  equation
    fc = (aC + aCs * pS / 100) / (aC + aCs);
    fE = (EC * aC + ECs * aCs) / (aC + aCs);
/*Temperature corresponding to 42.8% CaCl2 solution and -7.3Btu/lb enthalpy is 190 degree F*/
  end Ex9_12_a;

  //Title: Finding the amount of heat to be removed for crystallization to start
  model Ex9_12_b
  extends Ex9_12_a;
  /*Uses the values of parameter and values found in part a*/
  //parameter section
  parameter Real ECs2(unit="Btu/lb")=-83 "Enthaply of 43.8% solution at 70 degree F per pound solution";
  //variable section
  /*Crystallization will start at 70 degree F*/
  Real Hr(unit="Btu") "amount of Heat to be removed for crystallization";
  //equation section
  equation
  Hr=(aC+aCs)*(ECs2-fE);
  end Ex9_12_b;





end Ex9_12;
